/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.task;

import com.cisco.pt.ptmp.PacketTracerConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionNegotiationTask {
    private static Log logger = LogFactory.getLog(ConnectionNegotiationTask.class);
    protected PacketTracerConnection packetTracerConnection;

    public ConnectionNegotiationTask(PacketTracerConnection packetTracerConnection) {
        this.packetTracerConnection = packetTracerConnection;
    }

    public void negotiateConnection() throws IOException {
        StringBuffer typeAndPayload = new StringBuffer();
        typeAndPayload.append(0);
        typeAndPayload.append("\u0000");
        typeAndPayload.append(this.packetTracerConnection.connectionNegotiationProperties().toMessage());
        StringBuffer message = new StringBuffer();
        message.append(typeAndPayload.toString().length());
        message.append("\u0000");
        message.append(typeAndPayload.toString());
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        byteBuffer.put(message.toString().getBytes());
        byteBuffer.flip();
        int written = this.packetTracerConnection.write(byteBuffer);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Connection negotiation task wrote # of bytes: [" + written + "]"));
        }
        byteBuffer.clear();
        int read = this.packetTracerConnection.read(byteBuffer);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Connection negotiation task read # of bytes: [" + read + "]"));
        }
        byteBuffer.flip();
        byte[] responseBytes = new byte[read];
        for (int i = 0; i < read; ++i) {
            responseBytes[i] = byteBuffer.get(i);
        }
        String response = new String(responseBytes);
        logger.info((Object)("response = <" + response + ">"));
        StringTokenizer tokenizer = new StringTokenizer(response, "\u0000");
        int tokens = tokenizer.countTokens();
        if (tokens == 12) {
            tokenizer.nextToken();
            tokenizer.nextToken();
            this.packetTracerConnection.connectionNegotiationProperties().setSignature(tokenizer.nextToken());
            this.packetTracerConnection.connectionNegotiationProperties().setVersion(Integer.parseInt(tokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setServerUid(tokenizer.nextToken());
            this.packetTracerConnection.connectionNegotiationProperties().setEncoding(Integer.parseInt(tokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setEncryption(Integer.parseInt(tokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setCompression(Integer.parseInt(tokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setAuthentication(Integer.parseInt(tokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setServerTimestamp(tokenizer.nextToken());
            this.packetTracerConnection.connectionNegotiationProperties().setKeepAlivePeriod(Integer.parseInt(tokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setReserved(tokenizer.nextToken());
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Successfully negotiated connection");
                logger.info((Object)("with connection properties: [" + this.packetTracerConnection.connectionNegotiationProperties() + "]"));
            }
        } else {
            if (tokens == 3) {
                tokenizer.nextToken();
                String type = tokenizer.nextToken();
                String errMsg = tokenizer.nextToken();
                if (type.equals("7")) {
                    response = errMsg;
                    logger.error((Object)("Received invalid connection negotiation response: " + response));
                }
            }
            logger.error((Object)"Received invalid connection negotiation response");
            logger.error((Object)response);
            logger.error((Object)("tokens = " + tokens));
            for (int i = 0; i < tokens; ++i) {
                logger.error((Object)("token[" + i + "] = <" + tokenizer.nextToken() + ">"));
            }
            throw new IOException("Connection negotiation failed: " + response);
        }
    }
}

